/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import org.embeddedt.modernfix.render.FastItemRenderType;
import org.jetbrains.annotations.Nullable;

public class SimpleItemModelView
implements IBakedModel {
    private IBakedModel wrappedItem;
    private FastItemRenderType type;
    private final List<BakedQuad> nullQuadList = new ObjectArrayList();

    public void setItem(IBakedModel model) {
        this.wrappedItem = model;
    }

    public void setType(FastItemRenderType type) {
        this.type = type;
    }

    private boolean isCorrectDirectionForType(Direction direction) {
        if (this.type == FastItemRenderType.SIMPLE_ITEM) {
            return direction == Direction.SOUTH;
        }
        return direction == Direction.UP || direction == Direction.EAST || direction == Direction.NORTH;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        boolean isWholeListValid = this.isCorrectDirectionForType(side);
        List realList = this.wrappedItem.func_200117_a(state, side, rand);
        if (isWholeListValid) {
            return realList;
        }
        this.nullQuadList.clear();
        for (int i = 0; i < realList.size(); ++i) {
            BakedQuad quad = (BakedQuad)realList.get(i);
            if (!this.isCorrectDirectionForType(quad.func_178210_d())) continue;
            this.nullQuadList.add(quad);
        }
        return this.nullQuadList;
    }

    public boolean func_177555_b() {
        return this.wrappedItem.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.wrappedItem.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.wrappedItem.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.wrappedItem.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.wrappedItem.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.wrappedItem.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.wrappedItem.func_188617_f();
    }
}

