/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.caffeinemc.phosphor.common.chunk.light.BlockLightStorageAccess;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLightStorage;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.BlockLightStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockLightStorage.class})
public abstract class MixinBlockLightStorage
extends MixinLightStorage
implements BlockLightStorageAccess {
    @Unique
    private final LongSet lightEnabled = new LongOpenHashSet();

    @Override
    protected void func_215526_b(long chunkPos, boolean enable) {
        if (enable) {
            this.lightEnabled.add(chunkPos);
        } else {
            this.lightEnabled.remove(chunkPos);
        }
    }

    @Override
    public boolean isLightEnabled(long sectionPos) {
        return this.lightEnabled.contains(SectionPos.func_218169_f((long)sectionPos));
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
        return newVal - oldVal;
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, NibbleArray lightmap) {
        if (lightmap.func_215655_c()) {
            return 0;
        }
        int complexity = 0;
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += lightmap.func_76582_a(x, y, z);
                }
            }
        }
        return complexity;
    }

    @Override
    protected void beforeChunkEnabled(long chunkPos) {
    }

    @Override
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
    }
}

