/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.BitSet;
import net.caffeinemc.phosphor.common.block.BlockStateLightInfo;
import net.caffeinemc.phosphor.common.block.BlockStateLightInfoAccess;
import net.caffeinemc.phosphor.common.chunk.light.InitialLightingAccess;
import net.caffeinemc.phosphor.common.chunk.light.LightProviderUpdateTracker;
import net.caffeinemc.phosphor.common.chunk.light.LightStorageAccess;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLevelPropagator;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SectionLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LightEngine.class})
public abstract class MixinChunkLightProvider
extends MixinLevelPropagator
implements InitialLightingAccess,
LightProviderUpdateTracker {
    private static final BlockState DEFAULT_STATE = Blocks.field_150350_a.func_176223_P();
    private static final ChunkSection[] EMPTY_SECTION_ARRAY = new ChunkSection[16];
    @Shadow
    @Final
    protected BlockPos.Mutable field_215630_f;
    @Shadow
    @Final
    protected IChunkLightProvider field_215625_a;
    private final long[] cachedChunkPos = new long[2];
    private final ChunkSection[][] cachedChunkSections = new ChunkSection[2][];
    private final Long2ObjectOpenHashMap<BitSet> buckets = new Long2ObjectOpenHashMap();
    private long prevChunkBucketKey = ChunkPos.field_222244_a;
    private BitSet prevChunkBucketSet;
    private static final long BLOCK_TO_BUCKET_KEY_MASK = BlockPos.func_218276_a((int)15, (int)15, (int)15) ^ 0xFFFFFFFFFFFFFFFFL;
    @Shadow
    @Final
    protected SectionLightStorage<?> field_215627_c;

    @Inject(method={"clearChunkCache"}, at={@At(value="RETURN")})
    private void onCleanup(CallbackInfo ci) {
        if (this.cachedChunkPos != null) {
            Arrays.fill(this.cachedChunkPos, ChunkPos.field_222244_a);
            Arrays.fill((Object[])this.cachedChunkSections, null);
        }
    }

    @Unique
    protected boolean hasSection(long sectionPos) {
        return ((LightStorageAccess)this.field_215627_c).callHasSection(sectionPos);
    }

    @Unique
    protected NibbleArray getLightSection(long chunkId) {
        return ((LightStorageAccess)this.field_215627_c).callGetLightSection(chunkId, true);
    }

    @Unique
    protected BlockState getBlockStateForLighting(int x, int y, int z) {
        if (World.func_217405_b((int)y)) {
            return DEFAULT_STATE;
        }
        long chunkPos = ChunkPos.func_77272_a((int)(x >> 4), (int)(z >> 4));
        for (int i = 0; i < 2; ++i) {
            if (this.cachedChunkPos[i] != chunkPos) continue;
            return this.getBlockStateFromSection(this.cachedChunkSections[i], x, y, z);
        }
        return this.getBlockStateForLightingUncached(x, y, z);
    }

    private BlockState getBlockStateForLightingUncached(int x, int y, int z) {
        return this.getBlockStateFromSection(this.getAndCacheChunkSections(x >> 4, z >> 4), x, y, z);
    }

    private BlockState getBlockStateFromSection(ChunkSection[] sections, int x, int y, int z) {
        ChunkSection section = sections[y >> 4];
        if (section != null) {
            return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
        }
        return DEFAULT_STATE;
    }

    private ChunkSection[] getAndCacheChunkSections(int x, int z) {
        IChunk chunk = (IChunk)this.field_215625_a.func_217202_b(x, z);
        ChunkSection[] sections = chunk != null ? chunk.func_76587_i() : EMPTY_SECTION_ARRAY;
        ChunkSection[][] cachedSections = this.cachedChunkSections;
        cachedSections[1] = cachedSections[0];
        cachedSections[0] = sections;
        long[] cachedCoords = this.cachedChunkPos;
        cachedCoords[1] = cachedCoords[0];
        cachedCoords[0] = ChunkPos.func_77272_a((int)x, (int)z);
        return sections;
    }

    @Unique
    protected int getSubtractedLight(BlockState state, int x, int y, int z) {
        BlockStateLightInfo info = ((BlockStateLightInfoAccess)state).getLightInfo();
        if (info != null) {
            return info.getLightSubtracted();
        }
        return this.getSubtractedLightFallback(state, x, y, z);
    }

    private int getSubtractedLightFallback(BlockState state, int x, int y, int z) {
        return state.func_177230_c().func_200011_d(state, this.field_215625_a.func_212864_k_(), (BlockPos)this.field_215630_f.func_181079_c(x, y, z));
    }

    @Unique
    protected VoxelShape getOpaqueShape(BlockState state, int x, int y, int z, Direction dir) {
        if (state != null && state.func_215691_g()) {
            BlockStateLightInfo info = ((BlockStateLightInfoAccess)state).getLightInfo();
            if (info != null) {
                VoxelShape[] extrudedFaces = info.getExtrudedFaces();
                if (extrudedFaces != null) {
                    return extrudedFaces[dir.ordinal()];
                }
            } else {
                return this.getOpaqueShapeFallback(state, x, y, z, dir);
            }
        }
        return VoxelShapes.func_197880_a();
    }

    private VoxelShape getOpaqueShapeFallback(BlockState state, int x, int y, int z, Direction dir) {
        return VoxelShapes.func_216387_a((VoxelShape)state.func_235754_c_(this.field_215625_a.func_212864_k_(), (BlockPos)this.field_215630_f.func_181079_c(x, y, z)), (Direction)dir);
    }

    @Override
    public void cancelUpdatesForChunk(long sectionPos) {
        long key = this.getBucketKeyForSection(sectionPos);
        BitSet bits = this.removeChunkBucket(key);
        if (bits != null && !bits.isEmpty()) {
            int startX = SectionPos.func_218173_b((long)sectionPos) << 4;
            int startY = SectionPos.func_218144_c((long)sectionPos) << 4;
            int startZ = SectionPos.func_218153_d((long)sectionPos) << 4;
            int i = bits.nextSetBit(0);
            while (i != -1) {
                int x = i >> 8 & 0xF;
                int y = i >> 4 & 0xF;
                int z = i & 0xF;
                this.func_215479_e(BlockPos.func_218276_a((int)(startX + x), (int)(startY + y), (int)(startZ + z)));
                i = bits.nextSetBit(i + 1);
            }
        }
    }

    @Override
    protected void onPendingUpdateRemoved(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                return;
            }
        }
        bits.clear(MixinChunkLightProvider.getLocalIndex(blockPos));
        if (bits.isEmpty()) {
            this.removeChunkBucket(key);
        }
    }

    @Override
    protected void onPendingUpdateAdded(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                bits = new BitSet(4096);
                this.buckets.put(key, (Object)bits);
            }
            this.prevChunkBucketKey = key;
            this.prevChunkBucketSet = bits;
        }
        bits.set(MixinChunkLightProvider.getLocalIndex(blockPos));
    }

    private long getBucketKeyForBlock(long blockPos) {
        return blockPos & BLOCK_TO_BUCKET_KEY_MASK;
    }

    private long getBucketKeyForSection(long sectionPos) {
        return BlockPos.func_218276_a((int)(SectionPos.func_218173_b((long)sectionPos) << 4), (int)(SectionPos.func_218144_c((long)sectionPos) << 4), (int)(SectionPos.func_218153_d((long)sectionPos) << 4));
    }

    private BitSet removeChunkBucket(long key) {
        BitSet set = (BitSet)this.buckets.remove(key);
        if (this.prevChunkBucketSet == set) {
            this.prevChunkBucketKey = ChunkPos.field_222244_a;
            this.prevChunkBucketSet = null;
        }
        return set;
    }

    private static int getLocalIndex(long blockPos) {
        int x = BlockPos.func_218290_b((long)blockPos) & 0xF;
        int y = BlockPos.func_218274_c((long)blockPos) & 0xF;
        int z = BlockPos.func_218282_d((long)blockPos) & 0xF;
        return x << 8 | y << 4 | z;
    }

    @Shadow
    protected void func_215473_f(long id) {
    }

    @Shadow
    protected abstract int func_215622_a(NibbleArray var1, long var2);

    @Overwrite
    public void func_215620_a(ChunkPos pos, boolean enabled) {
        long chunkPos = SectionPos.func_218169_f((long)SectionPos.func_218166_b((int)pos.field_77276_a, (int)0, (int)pos.field_77275_b));
        LightStorageAccess lightStorage = (LightStorageAccess)this.field_215627_c;
        if (enabled) {
            lightStorage.invokeSetColumnEnabled(chunkPos, true);
            lightStorage.enableLightUpdates(chunkPos);
        } else {
            lightStorage.disableChunkLight(chunkPos, (LightEngine)this);
        }
    }

    @Override
    public void enableSourceLight(long chunkPos) {
        ((LightStorageAccess)this.field_215627_c).invokeSetColumnEnabled(chunkPos, true);
    }

    @Override
    public void enableLightUpdates(long chunkPos) {
        ((LightStorageAccess)this.field_215627_c).enableLightUpdates(chunkPos);
    }

    @Inject(method={"doLightUpdates(IZZ)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/LightStorage;notifyChanges()V")})
    private void runCleanups(CallbackInfoReturnable<Integer> ci) {
        ((LightStorageAccess)this.field_215627_c).runCleanups();
    }
}

