/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.caffeinemc.phosphor.common.util.collections.DoubleBufferedLong2ObjectHashMap;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightDataMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LightDataMap.class})
public abstract class MixinChunkToNibbleArrayMap {
    @Shadow
    private boolean field_215648_d;
    @Shadow
    @Final
    private long[] field_215646_b;
    @Shadow
    @Final
    private NibbleArray[] field_215647_c;
    @Shadow
    @Final
    protected Long2ObjectOpenHashMap<NibbleArray> field_215645_a;
    @Unique
    private DoubleBufferedLong2ObjectHashMap<NibbleArray> queue;
    @Unique
    private boolean isShared;
    @Unique
    private boolean init;

    @Shadow
    public abstract void func_215643_c();

    @Unique
    protected boolean isShared() {
        return this.isShared;
    }

    @Unique
    protected boolean isInitialized() {
        return this.init;
    }

    @Overwrite
    public void func_215641_a(long pos) {
        this.checkExclusiveOwner();
        this.queue.putSync(pos, this.queue.getSync(pos).func_215654_b());
        this.func_215643_c();
    }

    @Overwrite
    public NibbleArray func_215638_c(long pos) {
        if (this.field_215648_d) {
            long[] cachePositions = this.field_215646_b;
            for (int i = 0; i < cachePositions.length; ++i) {
                if (pos != cachePositions[i]) continue;
                return this.field_215647_c[i];
            }
        }
        return this.getUncached(pos);
    }

    @Unique
    private NibbleArray getUncached(long pos) {
        NibbleArray array = this.isShared ? this.queue.getAsync(pos) : this.queue.getSync(pos);
        if (array == null) {
            return null;
        }
        if (this.field_215648_d) {
            long[] cachePositions = this.field_215646_b;
            NibbleArray[] cacheArrays = this.field_215647_c;
            for (int i = cacheArrays.length - 1; i > 0; --i) {
                cachePositions[i] = cachePositions[i - 1];
                cacheArrays[i] = cacheArrays[i - 1];
            }
            cachePositions[0] = pos;
            cacheArrays[0] = array;
        }
        return array;
    }

    @Overwrite
    public void func_215640_a(long pos, NibbleArray data) {
        this.checkExclusiveOwner();
        this.queue.putSync(pos, data);
    }

    @Overwrite
    public NibbleArray func_223130_d(long chunkPos) {
        this.checkExclusiveOwner();
        return this.queue.removeSync(chunkPos);
    }

    @Overwrite
    public boolean func_215642_b(long chunkPos) {
        if (this.isShared) {
            return this.queue.getAsync(chunkPos) != null;
        }
        return this.queue.containsSync(chunkPos);
    }

    @Unique
    protected void checkExclusiveOwner() {
        if (this.isShared) {
            throw new IllegalStateException("Tried to synchronously write to light data array table after it was made shareable");
        }
    }

    @Unique
    protected DoubleBufferedLong2ObjectHashMap<NibbleArray> getUpdateQueue() {
        return this.queue;
    }

    protected void makeSharedCopy(DoubleBufferedLong2ObjectHashMap<NibbleArray> queue) {
        this.queue = queue;
        this.isShared = true;
        this.queue.flushChangesSync();
        this.init = true;
    }

    @Unique
    protected void init() {
        if (this.init) {
            throw new IllegalStateException("Map already initialized");
        }
        this.queue = new DoubleBufferedLong2ObjectHashMap();
        this.init = true;
    }
}

