/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.lighting.LevelBasedGraph;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelBasedGraph.class})
public abstract class MixinLevelPropagator
implements LevelPropagatorAccess {
    @Shadow
    @Final
    private Long2ByteMap field_215488_c;
    @Shadow
    @Final
    private int field_215486_a;
    @Shadow
    private volatile boolean field_215490_e;
    @Shadow
    private int field_215489_d;

    @Shadow
    protected abstract int func_215471_c(long var1);

    @Shadow
    protected abstract int func_215480_b(long var1, long var3, int var5);

    @Shadow
    protected abstract void func_215474_a(long var1, long var3, int var5, int var6, int var7, boolean var8);

    @Override
    @Invoker(value="propagateLevel")
    public abstract void invokePropagateLevel(long var1, long var3, int var5, boolean var6);

    @Shadow
    protected abstract void func_215475_b(long var1, long var3, int var5, boolean var6);

    @Shadow
    protected abstract void func_215479_e(long var1);

    @Override
    public void propagateLevel(long sourceId, long targetId, boolean decrease) {
        this.func_215475_b(sourceId, targetId, this.func_215471_c(sourceId), decrease);
    }

    @Override
    public void checkForUpdates() {
        this.field_215490_e = this.field_215489_d < this.field_215486_a;
    }

    @Unique
    protected void propagateLevel(long sourceId, BlockState sourceState, long targetId, int level, boolean decrease) {
        int resultLevel;
        boolean flag;
        int pendingLevel = this.field_215488_c.get(targetId) & 0xFF;
        int propagatedLevel = this.getPropagatedLevel(sourceId, sourceState, targetId, level);
        int clampedLevel = MathHelper.func_76125_a((int)propagatedLevel, (int)0, (int)(this.field_215486_a - 1));
        if (decrease) {
            this.func_215474_a(sourceId, targetId, clampedLevel, this.func_215471_c(targetId), pendingLevel, true);
            return;
        }
        if (pendingLevel == 255) {
            flag = true;
            resultLevel = MathHelper.func_76125_a((int)this.func_215471_c(targetId), (int)0, (int)(this.field_215486_a - 1));
        } else {
            resultLevel = pendingLevel;
            flag = false;
        }
        if (clampedLevel == resultLevel) {
            this.func_215474_a(sourceId, targetId, this.field_215486_a - 1, flag ? resultLevel : this.func_215471_c(targetId), pendingLevel, false);
        }
    }

    @Unique
    protected int getPropagatedLevel(long sourceId, BlockState sourceState, long targetId, int level) {
        return this.func_215480_b(sourceId, targetId, level);
    }

    @Redirect(method={"removePendingUpdate(JIIZ)V", "applyPendingUpdates"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ByteMap;remove(J)B", remap=false))
    private byte redirectRemovePendingUpdate(Long2ByteMap map, long key) {
        byte ret = map.remove(key);
        if (ret != map.defaultReturnValue()) {
            this.onPendingUpdateRemoved(key);
        }
        return ret;
    }

    @Redirect(method={"addPendingUpdate"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ByteMap;put(JB)B", remap=false))
    private byte redirectAddPendingUpdate(Long2ByteMap map, long key, byte value) {
        byte ret = map.put(key, value);
        if (ret == map.defaultReturnValue()) {
            this.onPendingUpdateAdded(key);
        }
        return ret;
    }

    @Unique
    protected void onPendingUpdateAdded(long key) {
    }

    @Unique
    protected void onPendingUpdateRemoved(long key) {
    }
}

