/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import net.caffeinemc.phosphor.common.chunk.light.ServerLightingProviderAccess;
import net.caffeinemc.phosphor.common.world.ThreadedAnvilChunkStorageAccess;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLightingProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorldLightManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerWorldLightManager.class})
public abstract class MixinServerLightingProvider
extends MixinLightingProvider
implements ServerLightingProviderAccess {
    @Shadow
    @Final
    private ChunkManager field_215607_d;

    @Shadow
    protected abstract void func_215600_a(int var1, int var2, IntSupplier var3, ServerWorldLightManager.Phase var4, Runnable var5);

    @Shadow
    protected abstract void func_215586_a(int var1, int var2, ServerWorldLightManager.Phase var3, Runnable var4);

    @Override
    public CompletableFuture<IChunk> setupLightmaps(IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        this.func_215600_a(chunkPos.field_77276_a, chunkPos.field_77275_b, () -> 0, ServerWorldLightManager.Phase.PRE_UPDATE, Util.func_215075_a(() -> {
            ChunkSection[] chunkSections = chunk.func_76587_i();
            for (int i = 0; i < chunkSections.length; ++i) {
                if (ChunkSection.func_222628_a((ChunkSection)chunkSections[i])) continue;
                super.func_215566_a(SectionPos.func_218156_a((ChunkPos)chunkPos, (int)i), false);
            }
            if (chunk.func_217310_r()) {
                super.enableSourceLight(SectionPos.func_218169_f((long)SectionPos.func_218166_b((int)chunkPos.field_77276_a, (int)0, (int)chunkPos.field_77275_b)));
            }
            super.enableLightUpdates(SectionPos.func_218169_f((long)SectionPos.func_218166_b((int)chunkPos.field_77276_a, (int)0, (int)chunkPos.field_77275_b)));
        }, () -> "setupLightmaps " + chunkPos));
        return CompletableFuture.supplyAsync(() -> {
            super.func_223115_b(chunkPos, false);
            return chunk;
        }, runnable -> this.func_215600_a(chunkPos.field_77276_a, chunkPos.field_77275_b, () -> 0, ServerWorldLightManager.Phase.POST_UPDATE, runnable));
    }

    @Overwrite
    public CompletableFuture<IChunk> func_215593_a(IChunk chunk, boolean excludeBlocks) {
        ChunkPos chunkPos = chunk.func_76632_l();
        this.func_215586_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ServerWorldLightManager.Phase.PRE_UPDATE, Util.func_215075_a(() -> {
            if (!chunk.func_217310_r()) {
                super.enableSourceLight(SectionPos.func_218169_f((long)SectionPos.func_218166_b((int)chunkPos.field_77276_a, (int)0, (int)chunkPos.field_77275_b)));
            }
            if (!excludeBlocks) {
                chunk.func_217304_m().forEach(blockPos -> super.func_215573_a((BlockPos)blockPos, chunk.func_217298_h(blockPos)));
            }
        }, () -> "lightChunk " + chunkPos + " " + excludeBlocks));
        return CompletableFuture.supplyAsync(() -> {
            chunk.func_217305_b(true);
            ((ThreadedAnvilChunkStorageAccess)this.field_215607_d).invokeReleaseLightTicket(chunkPos);
            return chunk;
        }, runnable -> this.func_215586_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ServerWorldLightManager.Phase.POST_UPDATE, runnable));
    }
}

