/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import net.caffeinemc.phosphor.common.chunk.light.IReadonly;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageAccess;
import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageDataAccess;
import net.caffeinemc.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.chunk.light.SkyLightChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.math.ChunkSectionPosHelper;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLightStorage;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SkyLightStorage;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={SkyLightStorage.class})
public abstract class MixinSkyLightStorage
extends MixinLightStorage
implements SkyLightStorageAccess {
    @Unique
    private final LongSet initSkylightChunks = new LongOpenHashSet();
    @Shadow
    @Final
    private LongSet field_215558_o;
    @Shadow
    private volatile boolean field_215553_p;
    @Unique
    private static final NibbleArray DIRECT_SKYLIGHT_MAP = new SkyLightChunkNibbleArray(ArrayUtils.toPrimitive((Byte[])new Byte[2048], (byte)-1));
    @Unique
    private static final NibbleArray EMPTY_SKYLIGHT_MAP = new EmptyChunkNibbleArray();
    @Unique
    private final Long2IntMap vanillaLightmapComplexities = new Long2IntOpenHashMap();
    @Unique
    private final LongSet removedLightmaps = new LongOpenHashSet();
    @Unique
    private final Long2IntMap scheduledHeightIncreases = (Long2IntMap)Util.func_200696_a((Object)new Long2IntOpenHashMap(), map -> map.defaultReturnValue(Integer.MIN_VALUE));
    @Unique
    private final LongSet scheduledHeightChecks = new LongOpenHashSet();

    /*
     * Unable to fully structure code
     */
    @Overwrite
    public int func_215525_d(long pos) {
        posX = BlockPos.func_218290_b((long)pos);
        posYOrig = BlockPos.func_218274_c((long)pos);
        posZ = BlockPos.func_218282_d((long)pos);
        chunkX = SectionPos.func_218159_a((int)posX);
        chunkYOrig = SectionPos.func_218159_a((int)posYOrig);
        chunkZ = SectionPos.func_218159_a((int)posZ);
        chunkOrig = SectionPos.func_218166_b((int)chunkX, (int)chunkYOrig, (int)chunkZ);
        lock = this.uncachedLightArraysLock;
        do lbl-1000:
        // 4 sources

        {
            block2: {
                stamp = lock.tryOptimisticRead();
                posY = posYOrig;
                chunkY = chunkYOrig;
                data = this.field_215538_e;
                sdata = (SkyLightStorageDataAccess)data;
                chunk = chunkOrig;
                height = sdata.getHeight(SectionPos.func_218169_f((long)chunk));
                if (height != sdata.getDefaultHeight() && chunkY < height) break block2;
                if (!lock.validate(stamp)) ** GOTO lbl-1000
                return 15;
            }
            array = data.func_215638_c(chunk);
            while (array == null) {
                block3: {
                    if (++chunkY < height) break block3;
                    if (!lock.validate(stamp)) ** GOTO lbl-1000
                    return 15;
                }
                chunk = ChunkSectionPosHelper.updateYLong(chunk, chunkY);
                array = data.func_215638_c(chunk);
                posY = chunkY << 4;
            }
        } while (!lock.validate(stamp));
        return array.func_76582_a(SectionPos.func_218171_b((int)posX), SectionPos.func_218171_b((int)posY), SectionPos.func_218171_b((int)posZ));
    }

    @Shadow
    protected abstract boolean func_215548_n(long var1);

    @Override
    public int getLightWithoutLightmap(long blockPos) {
        long sectionPos = SectionPos.func_218162_e((long)blockPos);
        NibbleArray lightmap = this.getLightmapAbove(sectionPos);
        if (lightmap == null) {
            return this.func_215548_n(sectionPos) ? 15 : 0;
        }
        return lightmap.func_76582_a(SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)blockPos)), 0, SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)blockPos)));
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, at=@At(value="NEW", target="()Lnet/minecraft/world/chunk/ChunkNibbleArray;"))
    private NibbleArray initializeLightmap(long pos) {
        NibbleArray ret = new NibbleArray();
        if (this.func_215548_n(pos)) {
            Arrays.fill(ret.func_177481_a(), (byte)-1);
        }
        return ret;
    }

    @Override
    protected void beforeChunkEnabled(long chunkPos) {
        long sectionPos;
        int y;
        int minHeight = Integer.MAX_VALUE;
        int height = Integer.MIN_VALUE;
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            y = it.nextInt();
            sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y);
            if (y < minHeight && (this.nonOptimizableSections.contains(sectionPos) || this.func_215520_a(sectionPos, true) != null)) {
                minHeight = y;
            }
            if (y <= height || !this.field_215535_b.contains(sectionPos)) continue;
            height = y;
        }
        this.updateMinHeight(minHeight);
        if (height != Integer.MIN_VALUE) {
            this.setHeight(chunkPos, height);
        }
        it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            y = it.nextInt();
            if (y <= height || this.field_215539_f.func_223130_d(sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y)) == null) continue;
            this.untrackSection(chunkPos, y);
            this.field_215540_g.add(sectionPos);
        }
        this.field_215539_f.func_215643_c();
        it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            long sectionPos2 = ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt());
            NibbleArray lightmap = this.func_215520_a(sectionPos2, true);
            if (lightmap == null) continue;
            this.initializeVanillaLightmapComplexity(sectionPos2, lightmap);
        }
    }

    @Override
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
        IntIterator it = removedLightmaps.iterator();
        while (it.hasNext()) {
            this.vanillaLightmapComplexities.remove(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()));
        }
        ((SkyLightStorageDataAccess)this.field_215539_f).setHeight(chunkPos, this.getMinHeight());
        this.scheduledHeightChecks.remove(chunkPos);
        this.scheduledHeightIncreases.remove(chunkPos);
    }

    @Override
    @Overwrite
    public void func_215526_b(long chunkPos, boolean enabled) {
        if (enabled) {
            if (this.enabledChunks.contains(chunkPos) && !this.field_215558_o.contains(chunkPos)) {
                this.initSkylightChunks.add(chunkPos);
                this.markForUpdates();
            } else {
                this.field_215558_o.add(chunkPos);
            }
        } else {
            this.field_215558_o.remove(chunkPos);
            this.initSkylightChunks.remove(chunkPos);
        }
    }

    @Unique
    private static void spreadSourceSkylight(LevelPropagatorAccess lightProvider, long src, Direction dir) {
        lightProvider.invokePropagateLevel(src, BlockPos.func_218289_a((long)src, (Direction)dir), 0, true);
    }

    @Unique
    private static void spreadZeroSkylight(LevelPropagatorAccess lightProvider, long src, Direction dir, int prevLight) {
        if (prevLight != 0) {
            lightProvider.invokePropagateLevel(src, BlockPos.func_218289_a((long)src, (Direction)dir), 15 - prevLight, false);
        }
    }

    @Unique
    private static void pullSkylight(LevelPropagatorAccess lightProvider, long dst, Direction dir) {
        lightProvider.propagateLevel(BlockPos.func_218289_a((long)dst, (Direction)dir), dst, true);
    }

    @Override
    protected void runCleanups(LightEngine<?, ?> lightProvider) {
        super.runCleanups(lightProvider);
        if (!this.field_215553_p) {
            return;
        }
        this.updateRemovedLightmaps();
        if (lightProvider == null) {
            this.func_215552_e();
        }
    }

    @Override
    @Overwrite
    public void func_215522_a(LightEngine<?, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        super.func_215522_a(lightProvider, doSkylight, skipEdgeLightPropagation);
        if (!doSkylight || !this.field_215553_p) {
            return;
        }
        this.updateHeights(lightProvider);
        this.lightChunks(lightProvider);
        this.field_215553_p = false;
    }

    @Unique
    private void updateHeights(LightEngine<?, ?> lightProvider) {
        int blockPosZ;
        LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
        if (!this.scheduledHeightIncreases.isEmpty()) {
            for (Long2IntMap.Entry entry : this.scheduledHeightIncreases.long2IntEntrySet()) {
                int height;
                long chunkPos = entry.getLongKey();
                int oldHeight = this.getHeight(chunkPos) - 1;
                for (height = entry.getIntValue(); height > oldHeight && !this.field_215535_b.contains(ChunkSectionPosHelper.updateYLong(chunkPos, height)); --height) {
                }
                if (height == oldHeight) continue;
                this.setHeight(chunkPos, height);
                int blockPosX = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)chunkPos));
                blockPosZ = SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)chunkPos));
                if (this.func_215520_a(ChunkSectionPosHelper.updateYLong(chunkPos, oldHeight + 1), true) != null) {
                    long blockPos = BlockPos.func_218276_a((int)blockPosX, (int)SectionPos.func_218142_c((int)(oldHeight + 1)), (int)blockPosZ);
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            MixinSkyLightStorage.pullSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)x, (int)0, (int)z), Direction.DOWN);
                        }
                    }
                }
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    if (!this.enabledChunks.contains(SectionPos.func_218172_a((long)chunkPos, (Direction)dir))) continue;
                    int ox = 15 * Math.max(dir.func_82601_c(), 0);
                    int oz = 15 * Math.max(dir.func_82599_e(), 0);
                    int dx = Math.abs(dir.func_82599_e());
                    int dz = Math.abs(dir.func_82601_c());
                    for (int y = height; y > oldHeight; --y) {
                        if (this.func_215520_a(ChunkSectionPosHelper.updateYLong(chunkPos, y), true) == null) continue;
                        long blockPos = BlockPos.func_218276_a((int)blockPosX, (int)SectionPos.func_218142_c((int)y), (int)blockPosZ);
                        for (int t = 0; t < 16; ++t) {
                            for (int dy = 0; dy < 16; ++dy) {
                                MixinSkyLightStorage.pullSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                            }
                        }
                    }
                }
            }
            this.scheduledHeightIncreases.clear();
        }
        if (!this.scheduledHeightChecks.isEmpty()) {
            LongIterator it = this.scheduledHeightChecks.iterator();
            while (it.hasNext()) {
                long sectionPos;
                long chunkPos = it.nextLong();
                int height = this.getHeight(chunkPos) - 1;
                if (!this.func_215550_a(height)) continue;
                if (this.field_215558_o.contains(chunkPos)) {
                    long sectionPos2;
                    while (this.func_215550_a(height) && !this.field_215535_b.contains(sectionPos2 = ChunkSectionPosHelper.updateYLong(chunkPos, height)) && !this.hasLightmap(sectionPos2)) {
                        if (this.func_215520_a(sectionPos2, true) != null) {
                            this.func_215528_a(lightProvider, sectionPos2);
                        }
                        --height;
                    }
                    this.setHeight(chunkPos, height);
                    continue;
                }
                int lightmapPosAbove = Integer.MIN_VALUE;
                NibbleArray lightmapAbove = null;
                while (this.func_215550_a(height) && !this.field_215535_b.contains(sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, height))) {
                    NibbleArray lightmap = this.func_215520_a(sectionPos, true);
                    if (lightmap != null) {
                        this.func_215528_a(lightProvider, sectionPos);
                        if (lightmapPosAbove == Integer.MIN_VALUE && !((IReadonly)lightmap).isReadonly()) {
                            lightmapPosAbove = height;
                            lightmapAbove = lightmap;
                        }
                    }
                    --height;
                }
                this.setHeight(chunkPos, height);
                if (lightmapPosAbove == Integer.MIN_VALUE) continue;
                int blockPosX = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)chunkPos));
                blockPosZ = SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)chunkPos));
                boolean hasSectionBelow = this.func_215550_a(height);
                for (int curY = lightmapPosAbove - 1; curY >= height; --curY) {
                    int x;
                    long curSectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, curY);
                    NibbleArray lightmap = this.getLightmap(curSectionPos);
                    if (curY > height && lightmap == null) continue;
                    if (curY == height && hasSectionBelow) {
                        if (lightmap == null) {
                            this.getOrAddLightmap(curSectionPos);
                            this.setLightmapComplexity(curSectionPos, this.vanillaLightmapComplexities.get(ChunkSectionPosHelper.updateYLong(chunkPos, lightmapPosAbove)));
                        } else {
                            int amount = 0;
                            for (int z = 0; z < 16; ++z) {
                                for (x = 0; x < 16; ++x) {
                                    amount += MixinSkyLightStorage.getComplexityChange(lightmap.func_76582_a(x, 15, z), lightmapAbove.func_76582_a(x, 0, z), 0);
                                }
                            }
                            this.changeLightmapComplexity(curSectionPos, amount);
                        }
                    }
                    for (int y = lightmapPosAbove; y > curY; --y) {
                        long sectionPos3 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                        if (this.func_215520_a(sectionPos3, true) == null) continue;
                        if (this.removeLightmap(sectionPos3)) {
                            this.vanillaLightmapComplexities.remove(sectionPos3);
                        }
                        if (!this.nonOptimizableSections.contains(sectionPos3)) continue;
                        this.field_215539_f.func_215640_a(sectionPos3, EMPTY_SKYLIGHT_MAP);
                    }
                    this.field_215539_f.func_215643_c();
                    if (curY == height && hasSectionBelow) {
                        long blockPos = BlockPos.func_218276_a((int)blockPosX, (int)SectionPos.func_218142_c((int)(height + 1)), (int)blockPosZ);
                        for (x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                MixinSkyLightStorage.spreadZeroSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)x, (int)0, (int)z), Direction.DOWN, lightmapAbove.func_76582_a(x, 0, z));
                            }
                        }
                    }
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        int ox = 15 * Math.max(dir.func_82601_c(), 0);
                        int oz = 15 * Math.max(dir.func_82599_e(), 0);
                        int dx = Math.abs(dir.func_82599_e());
                        int dz = Math.abs(dir.func_82601_c());
                        for (int y = lightmapPosAbove; y > curY; --y) {
                            long sectionPos4 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                            long neighborSectionPos = SectionPos.func_218172_a((long)sectionPos4, (Direction)dir);
                            if (!this.func_215518_g(neighborSectionPos)) continue;
                            long blockPos = BlockPos.func_218276_a((int)blockPosX, (int)SectionPos.func_218142_c((int)y), (int)blockPosZ);
                            for (int t = 0; t < 16; ++t) {
                                for (int dy = 0; dy < 16; ++dy) {
                                    int x2 = ox + t * dx;
                                    int z = oz + t * dz;
                                    MixinSkyLightStorage.spreadZeroSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)x2, (int)dy, (int)z), dir, lightmapAbove.func_76582_a(x2, y == lightmapPosAbove ? dy : 0, z));
                                }
                            }
                        }
                    }
                    lightmapPosAbove = curY;
                    lightmapAbove = lightmap;
                }
            }
            this.scheduledHeightChecks.clear();
        }
        levelPropagator.checkForUpdates();
    }

    @Unique
    private void lightChunks(LightEngine<?, ?> lightProvider) {
        if (this.initSkylightChunks.isEmpty()) {
            return;
        }
        LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
        LongIterator cit = this.initSkylightChunks.iterator();
        while (cit.hasNext()) {
            long chunkPos = cit.nextLong();
            int minY = this.getHeight(chunkPos) - 1;
            boolean hasSectionBelow = this.func_215550_a(minY);
            if (hasSectionBelow) {
                long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, minY);
                NibbleArray lightmap = this.getLightmap(sectionPos);
                if (lightmap == null) {
                    this.getOrAddLightmap(sectionPos);
                    this.setLightmapComplexity(sectionPos, 3840);
                } else {
                    int amount = 0;
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            amount += MixinSkyLightStorage.getComplexityChange(lightmap.func_76582_a(x, 15, z), 0, 15);
                        }
                    }
                    this.changeLightmapComplexity(sectionPos, amount);
                }
            }
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                int y = it.nextInt();
                if (y <= minY) continue;
                long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                this.removeLightmap(sectionPos);
                if (!this.nonOptimizableSections.contains(sectionPos)) continue;
                this.field_215539_f.func_215640_a(sectionPos, DIRECT_SKYLIGHT_MAP);
            }
            this.field_215539_f.func_215643_c();
            this.field_215558_o.add(chunkPos);
            int blockPosX = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)chunkPos));
            int blockPosZ = SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)chunkPos));
            if (hasSectionBelow) {
                long blockPos = BlockPos.func_218276_a((int)blockPosX, (int)SectionPos.func_218142_c((int)(minY + 1)), (int)blockPosZ);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)x, (int)0, (int)z), Direction.DOWN);
                    }
                }
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                long neighborChunkPos = SectionPos.func_218172_a((long)chunkPos, (Direction)dir);
                int ox = 15 * Math.max(dir.func_82601_c(), 0);
                int oz = 15 * Math.max(dir.func_82599_e(), 0);
                int dx = Math.abs(dir.func_82599_e());
                int dz = Math.abs(dir.func_82601_c());
                for (int y = this.getHeight(neighborChunkPos) - 1; y > minY; --y) {
                    if (!this.func_215518_g(ChunkSectionPosHelper.updateYLong(neighborChunkPos, y))) continue;
                    long blockPos = BlockPos.func_218276_a((int)blockPosX, (int)SectionPos.func_218142_c((int)y), (int)blockPosZ);
                    for (int t = 0; t < 16; ++t) {
                        for (int dy = 0; dy < 16; ++dy) {
                            MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, BlockPos.func_218291_a((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                        }
                    }
                }
            }
        }
        levelPropagator.checkForUpdates();
        this.initSkylightChunks.clear();
    }

    @Unique
    private void updateRemovedLightmaps() {
        while (!this.removedLightmaps.isEmpty()) {
            int y;
            long sectionPos = this.removedLightmaps.iterator().nextLong();
            if (!this.enabledChunks.contains(SectionPos.func_218169_f((long)sectionPos))) continue;
            long removedLightmapPosAbove = sectionPos;
            int height = this.getHeight(SectionPos.func_218169_f((long)sectionPos));
            if (height == this.getMinHeight()) {
                y = height;
            } else {
                for (y = SectionPos.func_218144_c((long)sectionPos); y < height && !this.hasLightmap(sectionPos = ChunkSectionPosHelper.updateYLong(sectionPos, y)); ++y) {
                    if (!this.removedLightmaps.contains(sectionPos)) continue;
                    removedLightmapPosAbove = sectionPos;
                }
            }
            NibbleArray lightmapAbove = y >= height ? (this.func_215548_n(sectionPos) ? DIRECT_SKYLIGHT_MAP : EMPTY_SKYLIGHT_MAP) : (this.vanillaLightmapComplexities.get(sectionPos) == 0 ? EMPTY_SKYLIGHT_MAP : this.func_215520_a(sectionPos, true));
            this.updateVanillaLightmapsBelow(removedLightmapPosAbove, lightmapAbove);
        }
    }

    @Overwrite
    private void func_215552_e() {
        this.field_215553_p = !this.initSkylightChunks.isEmpty() || !this.removedLightmaps.isEmpty() || !this.scheduledHeightIncreases.isEmpty() || !this.scheduledHeightChecks.isEmpty();
    }

    @Unique
    private void markForUpdates() {
        if (!this.field_215553_p) {
            this.field_215553_p = true;
        }
    }

    @Override
    public boolean func_215518_g(long sectionPos) {
        return super.func_215518_g(sectionPos) && this.func_215520_a(sectionPos, true) != null && !this.func_215549_m(sectionPos);
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/SkyLightStorage;queuedSections:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<NibbleArray> lightmapArray, long pos) {
        return null;
    }

    @Unique
    private static int getComplexityChange(int val, int oldNeighborVal, int newNeighborVal) {
        return Math.abs(newNeighborVal - val) - Math.abs(oldNeighborVal - val);
    }

    @Override
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
        long sectionPos = SectionPos.func_218162_e((long)blockPos);
        if (SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)blockPos)) == 0) {
            this.vanillaLightmapComplexities.put(sectionPos, this.vanillaLightmapComplexities.get(sectionPos) + newVal - oldVal);
            long sectionPosBelow = this.getSectionBelow(sectionPos);
            if (sectionPosBelow != Long.MAX_VALUE) {
                NibbleArray lightmapBelow = this.getOrAddLightmap(sectionPosBelow);
                int x = SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)blockPos));
                int z = SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)blockPos));
                this.changeLightmapComplexity(sectionPosBelow, MixinSkyLightStorage.getComplexityChange(lightmapBelow.func_76582_a(x, 15, z), oldVal, newVal));
            }
        } else if (this.field_215540_g.add(sectionPos)) {
            this.field_215539_f.func_215641_a(sectionPos);
            if (this.vanillaLightmapComplexities.get(sectionPos) != 0) {
                this.updateVanillaLightmapsBelow(sectionPos, this.func_215520_a(sectionPos, true));
            }
        }
    }

    @Override
    @Invoker(value="isAboveMinHeight")
    public abstract boolean callIsAboveMinHeight(int var1);

    @Shadow
    protected abstract boolean func_215550_a(int var1);

    @Shadow
    protected abstract boolean func_215549_m(long var1);

    @Unique
    private int getHeight(long chunkPos) {
        return ((SkyLightStorageDataAccess)this.field_215539_f).getHeight(chunkPos);
    }

    @Unique
    private int getMinHeight() {
        return ((SkyLightStorageDataAccess)this.field_215539_f).getDefaultHeight();
    }

    @Unique
    private void setHeight(long chunkPos, int height) {
        ((SkyLightStorageDataAccess)this.field_215539_f).setHeight(chunkPos, height + 1);
    }

    @Unique
    private void updateMinHeight(int y) {
        ((SkyLightStorageDataAccess)this.field_215539_f).updateMinHeight(y);
    }

    @Unique
    private long getSectionBelow(long sectionPos) {
        int y = SectionPos.func_218144_c((long)sectionPos);
        while (this.func_215550_a(y)) {
            if (this.func_215518_g(sectionPos = SectionPos.func_218172_a((long)sectionPos, (Direction)Direction.DOWN))) {
                return sectionPos;
            }
            --y;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, NibbleArray lightmap) {
        NibbleArray lightmapAbove;
        long sectionPos = SectionPos.func_218162_e((long)blockPos);
        int x = SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)blockPos));
        int y = SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)blockPos));
        int z = SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)blockPos));
        int valAbove = y < 15 ? lightmap.func_76582_a(x, y + 1, z) : ((lightmapAbove = this.getLightmapAbove(sectionPos)) == null ? this.getDirectSkylight(sectionPos) : lightmapAbove.func_76582_a(x, 0, z));
        int amount = MixinSkyLightStorage.getComplexityChange(valAbove, oldVal, newVal);
        if (y > 0) {
            amount += MixinSkyLightStorage.getComplexityChange(lightmap.func_76582_a(x, y - 1, z), oldVal, newVal);
        }
        return amount;
    }

    @Unique
    private NibbleArray getLightmapAbove(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        return sectionPosAbove == Long.MAX_VALUE ? null : this.func_215520_a(sectionPosAbove, true);
    }

    @Unique
    private long getSectionAbove(long sectionPos) {
        int height = this.getHeight(SectionPos.func_218169_f((long)sectionPos));
        if (height != this.getMinHeight()) {
            for (int y = SectionPos.func_218144_c((long)sectionPos) + 1; y < height; ++y) {
                if (!this.hasLightmap(sectionPos = ChunkSectionPosHelper.updateYLong(sectionPos, y))) continue;
                return sectionPos;
            }
        }
        return Long.MAX_VALUE;
    }

    @Unique
    private int getDirectSkylight(long sectionPos) {
        return this.func_215548_n(sectionPos) ? 15 : 0;
    }

    @Override
    protected void beforeLightmapChange(long sectionPos, NibbleArray oldLightmap, NibbleArray newLightmap) {
        int vanillaComplexity;
        long sectionPosBelow = this.getSectionBelow(sectionPos);
        int n = vanillaComplexity = oldLightmap == null ? 0 : this.initializeVanillaLightmapComplexity(sectionPos, newLightmap);
        if (sectionPosBelow != Long.MAX_VALUE) {
            NibbleArray lightmapBelow = this.getLightmap(sectionPosBelow);
            NibbleArray lightmapAbove = oldLightmap == null ? this.getLightmapAbove(sectionPos) : oldLightmap;
            int skyLight = this.getDirectSkylight(sectionPos);
            if (lightmapBelow == null) {
                int complexity = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        complexity += Math.abs(newLightmap.func_76582_a(x, 0, z) - (lightmapAbove == null ? skyLight : lightmapAbove.func_76582_a(x, 0, z)));
                    }
                }
                if (complexity != 0) {
                    this.getOrAddLightmap(sectionPosBelow);
                    this.setLightmapComplexity(sectionPosBelow, complexity);
                } else if (vanillaComplexity != 0) {
                    this.updateVanillaLightmapsBelow(sectionPos, newLightmap);
                }
            } else {
                int amount = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.func_76582_a(x, 15, z), lightmapAbove == null ? skyLight : lightmapAbove.func_76582_a(x, 0, z), newLightmap.func_76582_a(x, 0, z));
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, NibbleArray lightmap) {
        int x;
        int z;
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int skyLight = this.getDirectSkylight(sectionPos);
        if (lightmap.func_215655_c()) {
            return sectionPosAbove == Long.MAX_VALUE ? 256 * skyLight : this.vanillaLightmapComplexities.get(sectionPosAbove);
        }
        int complexity = 0;
        for (int y = 0; y < 15; ++y) {
            for (z = 0; z < 16; ++z) {
                for (x = 0; x < 16; ++x) {
                    complexity += Math.abs(lightmap.func_76582_a(x, y + 1, z) - lightmap.func_76582_a(x, y, z));
                }
            }
        }
        NibbleArray lightmapAbove = sectionPosAbove == Long.MAX_VALUE ? null : this.func_215520_a(sectionPosAbove, true);
        for (z = 0; z < 16; ++z) {
            for (x = 0; x < 16; ++x) {
                complexity += Math.abs((lightmapAbove == null ? skyLight : lightmapAbove.func_76582_a(x, 0, z)) - lightmap.func_76582_a(x, 15, z));
            }
        }
        return complexity;
    }

    @Override
    public void func_215476_a(long id, int level) {
        long chunkPos = SectionPos.func_218169_f((long)id);
        if (this.enabledChunks.contains(chunkPos)) {
            int oldLevel = this.func_215471_c(id);
            int y = SectionPos.func_218144_c((long)id);
            if (oldLevel != 0 && level == 0) {
                if (y + 1 > this.getHeight(chunkPos)) {
                    if (this.field_215558_o.contains(chunkPos)) {
                        this.setHeight(chunkPos, y);
                    } else if (y > this.scheduledHeightIncreases.get(chunkPos)) {
                        this.scheduledHeightIncreases.put(chunkPos, y);
                        this.markForUpdates();
                    }
                }
            } else if (oldLevel == 0 && level != 0) {
                if (y + 1 == this.getHeight(chunkPos)) {
                    this.scheduledHeightChecks.add(chunkPos);
                    this.markForUpdates();
                }
            } else if (oldLevel >= 2 && level < 2) {
                this.updateMinHeight(y);
            }
        }
        super.func_215476_a(id, level);
    }

    @Override
    protected NibbleArray createInitialVanillaLightmap(long sectionPos) {
        if (!this.field_215535_b.contains(sectionPos) && !this.field_215535_b.contains(SectionPos.func_218172_a((long)sectionPos, (Direction)Direction.UP))) {
            return this.createTrivialVanillaLightmap(sectionPos);
        }
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int complexity = sectionPosAbove == Long.MAX_VALUE ? (this.func_215548_n(sectionPos) ? 3840 : 0) : this.vanillaLightmapComplexities.get(sectionPosAbove);
        if (complexity == 0) {
            return EMPTY_SKYLIGHT_MAP;
        }
        NibbleArray lightmap = new NibbleArray(new byte[2048]);
        this.field_215539_f.func_215640_a(sectionPos, lightmap);
        this.trackSection(sectionPos);
        this.field_215539_f.func_215643_c();
        this.func_215524_j(sectionPos);
        this.setLightmapComplexity(sectionPos, complexity);
        return lightmap;
    }

    @Override
    protected NibbleArray createTrivialVanillaLightmap(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        if (sectionPosAbove == Long.MAX_VALUE) {
            return this.func_215548_n(sectionPos) ? DIRECT_SKYLIGHT_MAP : EMPTY_SKYLIGHT_MAP;
        }
        return this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? EMPTY_SKYLIGHT_MAP : new SkyLightChunkNibbleArray(this.func_215520_a(sectionPosAbove, true));
    }

    @Override
    @Overwrite
    public void func_215524_j(long sectionPos) {
        NibbleArray lightmap;
        int y = SectionPos.func_218144_c((long)sectionPos);
        this.updateMinHeight(y);
        long chunkPos = SectionPos.func_218169_f((long)sectionPos);
        if (y + 1 > this.getHeight(chunkPos)) {
            this.setHeight(chunkPos, y);
        }
        this.updateVanillaLightmapsBelow(sectionPos, this.initializeVanillaLightmapComplexity(sectionPos, lightmap = this.func_215520_a(sectionPos, true)) == 0 ? EMPTY_SKYLIGHT_MAP : lightmap);
    }

    @Unique
    private int initializeVanillaLightmapComplexity(long sectionPos, NibbleArray lightmap) {
        int complexity = 0;
        if (!lightmap.func_215655_c()) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += lightmap.func_76582_a(x, 0, z);
                }
            }
        }
        this.vanillaLightmapComplexities.put(sectionPos, complexity);
        return complexity;
    }

    @Override
    @Overwrite
    public void func_215523_k(long sectionPos) {
        if (this.vanillaLightmapComplexities.remove(sectionPos) != 0) {
            this.removedLightmaps.add(sectionPos);
            this.markForUpdates();
        }
        long chunkPos = SectionPos.func_218169_f((long)sectionPos);
        if (SectionPos.func_218144_c((long)sectionPos) + 1 == this.getHeight(chunkPos)) {
            this.scheduledHeightChecks.add(chunkPos);
            this.markForUpdates();
        }
    }

    @Unique
    private void updateVanillaLightmapsBelow(long sectionPos, NibbleArray lightmapAbove) {
        this.removedLightmaps.remove(sectionPos);
        NibbleArray lightmap = ((IReadonly)lightmapAbove).isReadonly() ? lightmapAbove : new SkyLightChunkNibbleArray(lightmapAbove);
        int y = SectionPos.func_218144_c((long)sectionPos) - 1;
        while (this.func_215550_a(y)) {
            long sectionPosBelow = SectionPos.func_218166_b((int)SectionPos.func_218173_b((long)sectionPos), (int)y, (int)SectionPos.func_218153_d((long)sectionPos));
            this.removedLightmaps.remove(sectionPosBelow);
            NibbleArray lightmapBelow = this.func_215520_a(sectionPosBelow, true);
            if (lightmapBelow != null) {
                if (!((IReadonly)lightmapBelow).isReadonly()) break;
                this.field_215539_f.func_215640_a(sectionPosBelow, lightmap);
                this.field_215540_g.add(sectionPosBelow);
            }
            --y;
        }
        this.field_215539_f.func_215643_c();
    }
}

